import numpy as np
import matplotlib.pyplot as plt
import matplotlib.backends.backend_tkagg as bt
import tkinter as tk

a = 5
f = 3

start = 0
stop = 0.99
num = 100

t = np.linspace(start, stop, num)
y = a*np.sin(2*np.pi*f*t)
z = a*np.cos(2*np.pi*f*t)

root = tk.Tk()
root.title('Multiple Sinusoid Plots')
root.geometry('1200x600')

fig, (ax1,ax2) = plt.subplots(nrows=1, ncols=2,
                              layout='constrained')
canvas = bt.FigureCanvasTkAgg(fig, root)
canvas.get_tk_widget().pack()

ax1.plot(t, y)
ax1.set_xlabel('Time (s)')
ax1.set_ylabel('Sine-Wave Displacement (cm)')

ax2.plot(t, z)
ax2.set_xlabel('Time (s)')
ax2.set_ylabel('Cosine-Wave Displacement (cm)')

canvas.draw()

root.mainloop()

